package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.WorkflowTemplate;
import gov.va.vinci.dart.biz.WorkflowType;
import gov.va.vinci.dart.db.WorkflowTemplateDAO;
import gov.va.vinci.dart.wf2.WorkflowResolver;

public class WorkflowTemplateDAOMock implements WorkflowTemplateDAO {
	private static final HashMap<Integer,WorkflowTemplate> IDHash = new HashMap<Integer,WorkflowTemplate>();
	private static final HashMap<Integer,WorkflowTemplate> GroupIDHash = new HashMap<Integer,WorkflowTemplate>();
	
	private static boolean initialized = false;

	@Override
	public WorkflowTemplate findById(int workflowTemplateId)
			throws ObjectNotFoundException {
		initializeWorkflowTemplateHash();
		
		WorkflowTemplate result = IDHash.get(workflowTemplateId);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}

		return result;
	}


	@Override
	public WorkflowTemplate findByGroupIdAndWorkflowTypeId(final int groupId, final int workflowTypeId)
			throws ObjectNotFoundException {
		initializeWorkflowTemplateHash();

		for (WorkflowTemplate template : listAll()) {
			if( template.getReviewer().getId() == groupId && template.getWorkflowTypeId() == workflowTypeId ) {
				return template;
			}
		}		
		
		throw new ObjectNotFoundException();
	}
	
	
//	@Override
//	public WorkflowTemplate findByGroupId(int groupId)
//			throws ObjectNotFoundException {
//		initializeWorkflowTemplateHash();
//
//		WorkflowTemplate result = GroupIDHash.get(groupId);
//		
//		if (result == null) {
//			throw new ObjectNotFoundException();
//		}
//
//		return result;
//	}

//	@Override
//	public List<WorkflowTemplate> listByGroupId(final int groupId) {
//		initializeWorkflowTemplateHash();
//
//		List<WorkflowTemplate> result = new ArrayList<WorkflowTemplate>();
//		result.add(GroupIDHash.get(groupId));
//
//		return result;
//	}

	
	@Override
	public List<WorkflowTemplate> listAll() {
		List<WorkflowTemplate> result = new ArrayList<WorkflowTemplate>();
		
		initializeWorkflowTemplateHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	@Override
	public List<WorkflowTemplate> listByWorkflowTypeId(final int workflowTypeId) {
		List<WorkflowTemplate> result = new ArrayList<WorkflowTemplate>();
		
		initializeWorkflowTemplateHash();
		
		for (Integer id: IDHash.keySet()) {
			WorkflowTemplate template = IDHash.get(id);
			
			if( template != null && template.getWorkflowTypeId() == workflowTypeId ) {	//found a WorkflowTemplate of the specified workflow type
				result.add(template);
			}
		}//end for

		return result;	
	}

	
	private void initializeWorkflowTemplateHash() {
		if (initialized == true) {
			return;
		}
		
		try {
			initializeWorkflowTemplateHash0();
			initialized = true;
		} catch (ObjectNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	private void initializeWorkflowTemplateHash0() throws ObjectNotFoundException {
		
		WorkflowTemplate wt = new WorkflowTemplate();
		wt.setId(1);
		wt.setName("NDS Workflow");
		wt.setDescription("NDS Workflow");
		wt.setReviewer(Group.findById(1));
		wt.setWorkflowTypeId(WorkflowResolver.WF_NDS);
		IDHash.put(wt.getId(), wt);
		GroupIDHash.put(wt.getReviewer().getId(), wt);

		wt.setId(2);
		wt.setName("Surgery Workflow");
		wt.setDescription("Surgery Workflow");
		wt.setReviewer(Group.findById(11));
		wt.setWorkflowTypeId(WorkflowResolver.WF_INDEPENDENT);
		IDHash.put(wt.getId(), wt);
		GroupIDHash.put(wt.getReviewer().getId(), wt);
	}
	
}
